% compute theoretical distribution

function [resMean, resStd] = EstimateMeanStdQ(gamma, P, N)

    C = gamma*gamma*(1-gamma)*(1-gamma);
    sizeS = size(P, 2); 
    
    EX = zeros(1, sizeS);
    VarX = zeros(1, sizeS);
    
    resMeanPI = 1;
    resVar1 = 1;
    resVar2 = 1;
    
    for i = 1:sizeS
        EX(i) = gamma*P(i) / (1 - gamma * (1-P(i)));
        resMeanPI = resMeanPI * EX(i);
        VarX(i) = C/(1-gamma*(1-P(i)))^4 * P(i)*(1 - P(i)) / N(i);
        resVar1 = resVar1 * (VarX(i) + (EX(i))^2);
        resVar2 = resVar2 * (EX(i))^2;
    end
    resVarPI = resVar1 - resVar2;
    
    resMean = resMeanPI / gamma;
    resStd = sqrt(resVarPI) / gamma;

end
